﻿' 版权所有 (C) Microsoft Corporation。保留所有权利。
Public Class WriteForm

    Private entryType As System.Diagnostics.EventLogEntryType = EventLogEntryType.Information

    Private Sub cmdWriteEntry_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) _
        Handles btnWriteEntry.Click

        Try
            If IsNumeric(txtEventID.Text) Then
                ' 第一个参数是要写入的日志的名称。第二个参数是
                ' 计算机名称。在本例中该名称是本地计算机名称。
                ' 第三个参数是事件源。通常将事件源设置为等同于
                ' 编写事件的应用程序的名称。
                Dim ev As New EventLog("Application", My.Computer.Name, "Event Log Sample")

                ' WriteEntry 的第一个参数是消息文本。第二个参数是
                ' 要创建的项类型（警告、信息等）
                ' 第三个参数是该事件的 eventID。用户可以使用它在帮助文件中查找
                ' 进一步的信息。
                ev.WriteEntry(txtEntry.Text, entryType, CInt(txtEventID.Text))

                ev.Close()

                MsgBox("Entry written to the event log", MsgBoxStyle.OKOnly, Me.Text)
            Else
                ' 该 EventID 不是数字
                MsgBox("Value entered into EventID text box must be numeric.", MsgBoxStyle.OKOnly, _
                    Me.Text & " Error")
            End If
        Catch secEx As System.Security.SecurityException
            MsgBox("Security error writing to the event log.", _
                MsgBoxStyle.OKOnly, Me.Text & " Error")
        Catch ex As Exception
            MsgBox("Error accessing logs on the local machine.", MsgBoxStyle.OKOnly, Me.Text & " Error")
        End Try
    End Sub

    Private Sub rdo_Click(ByVal sender As Object, ByVal e As System.EventArgs) _
        Handles rdoError.Click, rdoInfo.Click, rdoWarning.Click

        ' 该事件过程处理窗体的分组框中所有单选
        ' 按钮的 Click 事件。在该事件处理程序中，我们会知道单击了哪个
        ' 单选按钮，因为单选按钮作为“sender”参数传入。
        ' 该参数作为泛型对象传入，但必须将其强制转换回单选按钮
        ' 以便可以访问名称属性。

        Dim rdo As RadioButton = CType(sender, RadioButton)
        Select Case rdo.Name
            Case "rdoError"
                entryType = EventLogEntryType.Error
            Case "rdoWarning"
                entryType = EventLogEntryType.Warning
            Case "rdoInfo"
                entryType = EventLogEntryType.Information
            Case Else
                MsgBox("Select an entry type.")
        End Select

    End Sub

    Private Sub CloseToolStripMenuItem_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles CloseToolStripMenuItem.Click
        Me.Close()
    End Sub
End Class